﻿/*
Post-Deployment Script Template							
--------------------------------------------------------------------------------------
 This file contains SQL statements that will be appended to the build script.		
 Use SQLCMD syntax to include a file in the post-deployment script.			
 Example:      :r .\myfile.sql								
 Use SQLCMD syntax to reference a variable in the post-deployment script.		
 Example:      :setvar TableName MyTable							
               SELECT * FROM [$(TableName)]					
--------------------------------------------------------------------------------------
*/


delete from [dbo].[UiPageNavigation]

SET IDENTITY_INSERT [dbo].[UiPageNavigation] ON
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (1, N'~/Default.aspx', N'Home', N'Home', NULL, N'Welcome to the Veterans Affairs Scheduling Application. To find out additional user inforation, select a category from the drop down and press GO TO. For more detailed information please refer to our User Manual.  Thank You.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (2, N'~/About.aspx', N'About', N'About', 1, N'This application will allow you to schedule and manage appointments as well as run reports on real time data, select from each category to find out more.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (3, N'~/Account/ChangePassword.aspx', N'Change Password', N'Change Password', NULL, N'To change your password, select the Administration tab, then Users. A list of user names will display. To the right of the user name, a change password option displays. Select, change password, save. Note: This can be limited based on user role and permissions.' )
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (4, N'~/Account/ChangePasswordSuccess.aspx', N'Password Change Success', N'Password Change Success', NULL, N'After you change your password and press save, you will automatically be returned back to the Administration page. A message displays under "Users" stating your password has been changed.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (5, N'~/Account/Login.aspx', N'Login', N'Login', NULL, N'When you connect to the Scheduling Application you will be prompted to enter a Username and Password.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (6, N'~/Account/Register.aspx', N'Register', N'Register', NULL, N'To add yourself as a user, go to the Administration tab, select Users then Add User.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (7, N'~/Administration/ClinicDetails.aspx', N'Clinic Details', N'Details', 9, N'To view Clinic Details go to the VistA tab, select Facilities. Select a Facility from the list and choose View Clinics. Select the Clinic which you would like to see details for.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (8, N'~/Administration/ClinicEdit.aspx', N'Clinic Edit', N'Edit', 9, N'To edit a Clinic, select "Edit" from the bottom of the Clinic table when on the Clinic Details page.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (9, N'~/Administration/ClinicList.aspx', N'Clinics', N'Clinics', 12, N'To view a list of Clinics, from the VistA tab, select Facilities. Then select the Facility that you would like to see a list of Clinics for.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (10, N'~/Administration/FacilityDetails.aspx', N'Facility Details', N'Details', 12, N'To view Facility Details, from the VistA tab, select Facilities.  Then Select the Facility, next to the name of the Facility select the link on the last column labeled "Select".')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (11, N'~/Administration/FacilityEdit.aspx', N'Facility Edit', N'Edit', 12, N'To edit a Facility, from the VistA tab, select Facilities. Select the Facility.  You cannot edit a Facility as this information comes from VistA directly.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (12, N'~/Administration/FacilityList.aspx', N'Facilities', N'Facilities', 1, N'To view a list of Facilities, from the VistA tab, select Facilities. The list of Facilities within that Site will display.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (13, N'~/Administration/SiteDetails.aspx', N'Site Details', N'Details', 14, N'To view Site details, from the VistA tab, select Sites. A Site Listing table will display which each Sites general information.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (14, N'~/Administration/SiteList.aspx', N'Sites', N'Sites', 1, N'To view a Site list, from the VistA tab, select Sites. A Site Listing table will display which each Sites general information.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (15, N'~/Administration/Resources/ResouceDetails.aspx', N'Resouce Details', N'Details', 17, N'To view Resource Details, select a Clinic, then Clinic Resources. Select a resource and the resource details display.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (16, N'~/Administration/Resources/ResourceEdit.aspx', N'Resource Edit', N'Edit', 17, N'To edit a Resource, select a Clinic, then Clinic Resources. Select a Resource then select "Edit".')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (17, N'~/Administration/Resources/ResourceList.aspx', N'Resource List', N'Resources', 7, N'To view a Resource List, select a Clinic. Then select the link labeled "Clinic Resource List"')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (18, N'~/Administration/Schedules/ApointmentTypeEdit.aspx', N'Apointment Type Edit', N'Edit', 19, N'To edit an Appointment Type, select a Clinic, choose the Appointment List Type link. Select a Appointment Type by chooseing the "Select" link in the far right column of the table.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (19, N'~/Administration/Schedules/ApointmentTypeListaspx.aspx', N'Apointment Types', N'Types', 7, N'Add an Appointment Type for each Clinic so that Patient Appointments can be added for the Clinic. To complete this, select a Clinic, then appointment Type listing and Add Appointment Type.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (20, N'~/Administration/Schedules/BlockEdit.aspx', N'Block Edit', N'Edit', 21, N'Select a Clinic, select Block List. Select the Block you want to Edit.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (21, N'~/Administration/Schedules/BlockList.aspx', N'Blocks', N'Blocks', 15, N'From the VistA tab, select Facilities. Select a Facility from the list, then select a Clinic. Select Block List.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (22, N'~/Administration/Schedules/HoldEdit.aspx', N'Hold Edit', N'Edit', 23, N'Select a Clinic, then select On-Hold List.  List will display, select the Hold Listing you want to Edit.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (23, N'~/Administration/Schedules/HoldList.aspx', N'Holds', N'Holds', 15, N'Select a Clinic, then select On-Hold List.  List will display.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (24, N'~/Administration/Schedules/ScheduleEdit.aspx', N'Schedule Edit', N'Edit', 25, N'Select a Clinic, select the link "Clinic Resource List". Select a Resource. Select Scheduling Policies List. Select the day of the week you want to Edit.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (25, N'~/Administration/Schedules/ScheduleList.aspx', N'Schedule', N'Schedule', 15, N'Select a Clinic, select the link "Clinic Resource List". Select a Resource. Select Scheduling Policies List.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (26, N'~/Administration/Schedules/SlotEdit.aspx', N'Slot Edit', N'Edit', 27, N'Select a Clinic, select the link "Clinic Resource List". Select a Resource. Select Scheduling Policies List then select the policy for one day. Select "View Slots". Select the link titled "Select" next to a particular time slot to edit. Once complete, select "Update".')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (27, N'~/Administration/Schedules/SlotList.aspx', N'Slots', N'Slots', 25,  N'Select a Clinic, select the link "Clinic Resource List". Select a Resource. Select Scheduling Policies List then select the policy for one day. Select "View Slots".')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (28, N'~/Administration/Templates/TemplateList.aspx', N'Templates', N'Templates', 7, N'Select a Clinic, select the link "Communications Template List". A list will display.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (29, N'~/Administration/Templates/TemplateUpload.aspx', N'Template Upload', N'Upload', 28, N'Select a Clinic, select the link "Add Communication Template".')

INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (71, N'~/Patient/TeleHealth.aspx', N'Patient TeleHealth Appointment', N'Patient TeleHealth Appointment', 1, N'Select the Appointments tab, choose Tele-Health. Choose a Patient and you will be prompted to add a tele-health appointment.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (72, N'~/Patient/ClinicSchedule.aspx', N'Clinic Schedule', N'Clinic Schedule', 1, N' To view a Clinic Schedule, go to the Appointments tab, and select "Clinic Schedule". Choose the Facility and Clinic that you want to view information for.  The Clinic Schedule shows the Clinic and that Clinic''s provider hours.')

INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (70, N'~/Patient/PatientSearch.aspx', N'Patient Search', N'Patient Search', 1, N'Select the Appointments tab, then "Add an Appointment". Select "Select Patient", on the far right of the page.' )
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (50, N'~/Patient/WaitingList.aspx', N'Waiting List', N'Waiting List', 1, N'Select the Appointments tab then choose "Waiting Lists".')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (30, N'~/Patient/PatientAppointmentList.aspx', N'Patient Appointments', N'Patient Appointments', 1, N'Select the Appointments tab, then choose "Patient Appointments".')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (31, N'~/Patient/PatientAppointmentAdd.aspx', N'Add Patient Appointment', N'Add Appointment', 30, N'Select the Appointments tab, then choose "Patient Appointments". If you do not have a patient selected, select one and choose "Add Appointment".')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (47, N'~/Patient/PatientAppointmentRequestAdd.aspx', N'Add Patient Appointment Request', N'Add Request', 30, N'Select the Appointments tab, then choose "Add Appointment Request." If you do not have a patient selected, select one and then choose "Add Appointment Request".')

INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (45, N'~/Patient/PatientAppointmentEdit.aspx', N'Edit Patient Appointment', N'Edit', 30, N'Select the Appointments tab, select a Patient. A list of appointments will display and here you can Change Provider, View in Provider Roster, Reschedule Appointment, or Cancel the Appointment.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (60, N'~/Patient/PatientAppointmentCancel.aspx', N'Cancel Patient Appointment', N'Cancel', 30, N'Select the Appointments tab, select a Patient. Select the appointment you want to cancel, select "Cancel the Appointment" on right of the appointment.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (61, N'~/Patient/PatientAppointmentReschedule.aspx', N'Reschedule Patient Appointment', N'Reschedule', 30, N'Select the Appointment tab then select Provider Roster. A calendar will display allowing you to sort on the Site Provider, Facility, and Clinic.')

INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (39, N'~/Patient/GroupAppointmentsList.aspx', N'Group Appointments', N'Group Appointments', 1, N' To view Group Appointments, go to the Appointments tab, select "Group Appointment". If a message appears at the top of the screen, select the button labeled "This Week".  This screen allows you to view Group Appointments based on a date, Facility, Clinic, and Provider.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (40, N'~/Patient/GroupAppointmentAdd.aspx', N'Add Group Appointment', N'Add', 39, N' To add a Group Appointment from Appointments, select "Group Appointment" from the Appointments tab. Select an Appointment on the calendar. These appointments are those which a provider has the ability to see more than one patient at a time. Once the appointment is selected you can add patients to that group appointment.')

INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (46, N'~/Patient/ProviderRoster.aspx', N'Provider Roster', N'Roster', 1, N' To view the Provider Roster, from the Appointments tab, select "Provider Roster". Selecting "View Patients" displays all patients with scheduled appointments with the provider selected in the drop down.')

INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (55, N'~/Patient/ResourceView.aspx', N'Resources', N'Resources View', 1, N'Select a Clinic, then select "Clinic Resources List".  A list of your Resources displays.')

INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (32, N'~/Help.aspx', N'Help', N'Help', 1, N'The Help tab supplies additional information about each section within the application.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (33, N'~/Administration/Users/Users.aspx', N'Users', N'Users', 1, N'To see a list of users, select the Administration tab, then choose "Users" from the drop down.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (34, N'~/Administration/Users/Roles.aspx', N'Roles', N'Roles', 1, N'Within the Scheduler Application there is built in security based on user rights based on roles.  A user role is assigned to a user and can be accessed by going to the Administration tab and selecting "Users".')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (35, N'~/Administration/Users/UsersInRoles.aspx', N'Users In Roles', N'Users In Roles', 1, N'The Users in Roles section can be accessed by going to the "Administration" tab and selecting "Users in Roles". This page displays the name of the user designated to a specific role in the Scheduling Application. You can sort this by selecting the "Roles" drop down on this page.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (36, N'~/Administration/Users/Actions.aspx', N'Actions', N'Actions', 1, N'Actions are fixed within the system and cannot be edited.  A list of actions can be viewed by going to Administration tab and selecting "Actions".')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (37, N'~/Administration/Users/RoleActions.aspx', N'Role Actions', N'Roles Actions', 1, N'Select the Administration tab, then "Role Actions". A listing of all the sections a particular user role has access to are checked. To view the role actions another role can view, select a different option from the role dropdown.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (38, N'~/Patient/PatientCheckIn.aspx', N'Patient Check in', N'Check in', 30, N'To check in a patient, select the Appointments tab, then "Patient Check-In".')

INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (41, N'~/Administration/Resources/Roomlist.aspx', N'Room Lists in', N'Rooms', 12, N'From the VistA tab, select Facilities,then Rooms List.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (42, N'~/Administration/Resources/RoomEdit.aspx', N'Room Edit in', N'Edit', 41, N'From the VistA tab, select Facilities, Rooms List, select a room.  Once you have completed your changes, select "Update".')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (43, N'~/Administration/Resources/EquipmentList.aspx', N'Equipment Lists in', N'Equipment', 12, N'From the VistA tab, select Facilities, then Equipment list.')
INSERT INTO [dbo].[UiPageNavigation] ([Id], [PageAddress], [PageTitle], [BreadcrumbText], [ParentPageId], [PageHelp]) VALUES (44, N'~/Administration/Resources/EquipmentEdit.aspx', N'Equipment Edit in', N'Edit', 43, N'From the VistA tab, select Facilities, Equipment list, select a piece of Equipment.  Once you have completed your changes, select "Update".')



SET IDENTITY_INSERT [dbo].[UiPageNavigation] OFF
